<?php

require_once 'wp-async-task-master/wp-async-task.php';
require_once 'slp_extensions.php';

$apiPath = "https://api.digestbuilder.com";
// $apiPath = "https://staging-api.digestbuilder.com";
// $apiPath = "http://localhost:3010";

function getTagToExclude()
{
  global $wpdb;
  $configName = "exclude_tag_id";

  $result = $wpdb->get_results(
    "SELECT * FROM " . $wpdb->prefix . "slp_digest"
      . " WHERE config_name = \"$configName\""
  );

  if ($result) {
    return $result[0]->value;
  } else {
    return null;
  }
}

function saveTagToExclude($tag_id)
{
  global $wpdb;
  $result = false;
  $configName = "exclude_tag_id";

  $result = $wpdb->get_results(
    "SELECT * FROM " . $wpdb->prefix . "slp_digest"
      . " WHERE config_name = \"$configName\""
  );

  if ($result) {
    $result = $wpdb->update(
      $wpdb->prefix . 'slp_digest',
      array('value' => $tag_id),
      array('config_name' => $configName),
      array('%s'),
      array('%s')
    );
  } else {
    $result = $wpdb->insert(
      $wpdb->prefix . 'slp_digest',
      array('config_name' => $configName, 'value' => $tag_id),
      array('%s', '%s')
    );
  }

  if ($wpdb->last_error) {
    return array(
      'result' => 'error',
      'message' => 'Error saving tag to the database. Please try again.'
    );
  } else {
    return array('result' => 'success');
  }
}

function getMobileFeaturedImageEnabled()
{
  global $wpdb;
  $configName = "mobile_featured_image";

  $result = $wpdb->get_results(
    "SELECT * FROM " . $wpdb->prefix . "slp_digest"
      . " WHERE config_name = \"$configName\""
  );

  if ($result) {
    return $result[0]->value;
  } else {
    return null;
  }
}

function saveMobileFeaturedImageEnabled($enabled)
{
  global $wpdb;
  $result = false;
  $configName = "mobile_featured_image";

  $result = $wpdb->get_results(
    "SELECT * FROM " . $wpdb->prefix . "slp_digest"
      . " WHERE config_name = \"$configName\""
  );

  if ($result) {
    $result = $wpdb->update(
      $wpdb->prefix . 'slp_digest',
      array('value' => $enabled),
      array('config_name' => $configName),
      array('%s'),
      array('%s')
    );
  } else {
    $result = $wpdb->insert(
      $wpdb->prefix . 'slp_digest',
      array('config_name' => $configName, 'value' => $enabled),
      array('%s', '%s')
    );
  }

  if ($wpdb->last_error) {
    return array(
      'result' => 'error',
      'message' => 'Error saving Featured Image to the database. Please try again.'
    );
  } else {
    return array('result' => 'success');
  }
}

function getDraftQueueEnabled()
{
  global $wpdb;
  $configName = "draft_queue";

  $result = $wpdb->get_results(
    "SELECT * FROM " . $wpdb->prefix . "slp_digest"
      . " WHERE config_name = \"$configName\""
  );

  if ($result) {
    return $result[0]->value;
  } else {
    return null;
  }
}


function saveDraftQueueEnabled($enabled)
{
  global $wpdb;
  $result = false;
  $configName = "draft_queue";

  $result = $wpdb->get_results(
    "SELECT * FROM " . $wpdb->prefix . "slp_digest"
      . " WHERE config_name = \"$configName\""
  );

  if ($result) {
    $result = $wpdb->update(
      $wpdb->prefix . 'slp_digest',
      array('value' => $enabled),
      array('config_name' => $configName),
      array('%s'),
      array('%s')
    );
  } else {
    $result = $wpdb->insert(
      $wpdb->prefix . 'slp_digest',
      array('config_name' => $configName, 'value' => $enabled),
      array('%s', '%s')
    );
  }

  if ($wpdb->last_error) {
    return array(
      'result' => 'error',
      'message' => 'Error saving Draft Queue configuration to the database. Please try again.'
    );
  } else {
    return array('result' => 'success');
  }
}

function querySmartBannerData() {
  global $wpdb;

  // Get smart banner data from the config table
  $configNames = array("smart_banner_enabled", "days_hidden", "days_reminder", "app_icon_path", "ios_app_id", "android_app_id", "ios_app_url", "android_app_url", "app_name", "org_name");
  return $wpdb->get_results(
    "SELECT * FROM " . $wpdb->prefix . "slp_digest"
      . " WHERE config_name IN (\"" 
      . $configNames[0] . "\", \"" 
      . $configNames[1] . "\", \"" 
      . $configNames[2] . "\", \"" 
      . $configNames[3] . "\", \"" 
      . $configNames[4] . "\", \"" 
      . $configNames[5] . "\", \"" 
      . $configNames[6] . "\", \"" 
      . $configNames[7] . "\", \"" 
      . $configNames[8] . "\", \"" 
      . $configNames[9] . "\")"
  );
}

function parseSmartBannerData($bannerData) 
{
  $parsedData = array();
  foreach ($bannerData as $item) {
    $parsedData[$item->config_name] = $item->value;
  }
  return $parsedData;
}

function getSmartBannerData()
{
  global $wpdb;

  $bannerData = querySmartBannerData();

  // If no data exists then create it
  $table_name = $wpdb->prefix . 'slp_digest';
  if (count($bannerData) == 0) {
    $wpdb->insert($table_name, array(
      'config_name' => 'smart_banner_enabled',
      'value' => false,
    ), array('%s', '%d'));
    $wpdb->insert($table_name, array(
      'config_name' => 'days_hidden',
      'value' => 15,
    ), array('%s', '%d'));
    $wpdb->insert($table_name, array(
      'config_name' => 'days_reminder',
      'value' => 90,
    ), array('%s', '%d'));
    $bannerData = querySmartBannerData();
  } 

  return parseSmartBannerData($bannerData);
}

function saveSmartBannerData($enabled, $daysHidden, $daysReminder)
{
  global $wpdb;
  $table_name = $wpdb->prefix . 'slp_digest';
  $configNames = array("days_hidden", "days_reminder");

  if ($enabled) {
    $appDetails = retrieveAppDetails();
    if (!$appDetails->ios_app_id || !$appDetails->android_app_id) {
      return array(
        'result' => 'error',
        'message' => 'Unable to retrieve iOS and Android Store URL from DigestBuilder.'
      );
    }
  }

  // Check if values are integers
  if (!ctype_digit(strval($daysHidden)) || !ctype_digit(strval($daysReminder))) {
    return array(
      'result' => 'error',
      'message' => 'The value for "Days to hide banner" needs to be a number.'
    );
  }

  $wpdb->update(
    $table_name,
    array('value' => $enabled),
    array('config_name' => 'smart_banner_enabled'),
    array('%s'),
    array('%s')
  );
  $wpdb->update(
    $table_name,
    array('value' => $daysHidden),
    array('config_name' => 'days_hidden'),
    array('%s'),
    array('%s')
  );
  $wpdb->update(
    $table_name,
    array('value' => $daysReminder),
    array('config_name' => 'days_reminder'),
    array('%s'),
    array('%s')
  );

  if ($wpdb->last_error !== '') {
    return array(
      'result' => 'error',
      'message' => 'There was an error while enabling SmartBanner. Please try again.'
    );
  } else {
    return array('result' => 'success');
  }
}

function extractSelectedCustomPostTypes($postData) {
  $customPostTypes = getRegisteredCustomPostTypes();

  $result = array();
  foreach ($customPostTypes as $key => $postType) {
    $postDataKey = 'registered_post_type_' . $key;
    if (array_key_exists($postDataKey, $postData)) {
      $isChecked = $postData[$postDataKey] == 'on';
      if ($isChecked) {
        $result[] = $postType;
      }
    }
  }

  return $result;
}

function custom_postimage_meta_box()
{
  //on which post types should the box appear?
  $post_types = array('post', 'page');
  foreach ($post_types as $pt) {
    add_meta_box('custom_postimage_meta_box', __('Mobile App Image', 'localhost'), 'custom_postimage_meta_box_func', $pt, 'side', 'low');
  }
}

function custom_postimage_meta_box_func($post)
{
  // Array with all the image meta tag
  $meta_keys = array('mobile_featured_image');

  foreach ($meta_keys as $meta_key) {
    $image_meta_val = get_post_meta($post->ID, $meta_key, true);

    // Get mobile featured image src
    $featured_img_src = '';
    $featured_img_display = 'none';
    if ($image_meta_val != '') {
      $attachments = wp_get_attachment_image_src($image_meta_val);
      if (is_array($attachments) && count($attachments) > 0) {
        $featured_img_src = $attachments[0];
        $featured_img_display = 'block';
      }
    }

    ?>
    <div class="custom_postimage_wrapper" id="<?php echo $meta_key; ?>_wrapper" style="margin-bottom:20px;">
      <img src="<?php echo $featured_img_src; ?>" style="width:100%;display: <?php echo $featured_img_display; ?>" alt="">
      <a class="addimage button" onclick="custom_postimage_add_image('<?php echo $meta_key; ?>');"><?php _e('Set mobile app image', 'localhost'); ?></a><br>
      <a class="removeimage" style="color:#a00;cursor:pointer;display: <?php echo ($image_meta_val != '' && $image_meta_val != '0' ? 'block' : 'none'); ?>" onclick="custom_postimage_remove_image('<?php echo $meta_key; ?>');"><?php _e('remove image', 'localhost'); ?></a>
      <input type="hidden" name="<?php echo $meta_key; ?>" id="<?php echo $meta_key; ?>" value="<?php echo $image_meta_val; ?>" />
    </div>
  <?php
    } ?>
  <script>
    function custom_postimage_add_image(key) {

      var $wrapper = jQuery('#' + key + '_wrapper');

      custom_postimage_uploader = wp.media.frames.file_frame = wp.media({
        title: '<?php _e('select image', 'localhost'); ?>',
        button: {
          text: '<?php _e('select image', 'localhost'); ?>'
        },
        multiple: false
      });
      custom_postimage_uploader.on('select', function() {

        var attachment = custom_postimage_uploader.state().get('selection').first().toJSON();
        var img_url = attachment['url'];
        var img_id = attachment['id'];
        $wrapper.find('input#' + key).val(img_id);
        $wrapper.find('img').attr('src', img_url);
        $wrapper.find('img').show();
        $wrapper.find('a.removeimage').show();
      });
      custom_postimage_uploader.on('open', function() {
        var selection = custom_postimage_uploader.state().get('selection');
        var selected = $wrapper.find('input#' + key).val();
        if (selected) {
          selection.add(wp.media.attachment(selected));
        }
      });
      custom_postimage_uploader.open();
      return false;
    }

    function custom_postimage_remove_image(key) {
      var $wrapper = jQuery('#' + key + '_wrapper');
      $wrapper.find('input#' + key).val('');
      $wrapper.find('img').hide();
      $wrapper.find('a.removeimage').hide();
      return false;
    }
  </script>
<?php
  wp_nonce_field('custom_postimage_meta_box', 'custom_postimage_meta_box_nonce');
}

function custom_postimage_meta_box_save($post_id)
{
  if (!current_user_can('edit_posts', $post_id)) {
    return 'not permitted';
  }

  if (isset($_POST['custom_postimage_meta_box_nonce']) && wp_verify_nonce($_POST['custom_postimage_meta_box_nonce'], 'custom_postimage_meta_box')) {

    //same array as in custom_postimage_meta_box_func($post)
    $meta_keys = array('mobile_featured_image');
    foreach ($meta_keys as $meta_key) {
      if (isset($_POST[$meta_key]) && intval($_POST[$meta_key]) != '') {
        update_post_meta($post_id, $meta_key, intval($_POST[$meta_key]));
      } else {
        update_post_meta($post_id, $meta_key, '');
      }
    }
  }
}

register_rest_field('post', 'slp_mobile_featured_image', array(
  'get_callback' => function ($data) {
    $image_path = null;
    $mobileImageId = get_post_meta($data['id'], 'mobile_featured_image', true);
    if (!$mobileImageId) {
      $mobileImageId = get_post_thumbnail_id($data['id']);
    }

    if ($mobileImageId) {
      // Get caption
      $attachment = get_post($mobileImageId);
      $caption = $attachment->post_excerpt;

      // Get image path
      $image_data = wp_get_attachment_image_src($mobileImageId, 'full');
      if ($image_data) {
        $image_path = $image_data[0];
      }

      return array(
        'id' => $mobileImageId,
        'href' => get_rest_url() . 'wp/v2/media/' . $mobileImageId,
        'image_path' => $image_path,
        'caption' => $caption
      );
    } else {
      return null;
    }
  },
));

function getDigestBuilderId()
{
  global $wpdb;
  $result = $wpdb->get_results("
    SELECT * FROM " . $wpdb->prefix . "slp_digest
    WHERE config_name = 'digestbuilder-id'
  ");
  if (count($result) > 0) {
    return $result[0]->value;
  }
  return '';
}

function getApplicationIdSelected()
{
  global $wpdb;
  $result = $wpdb->get_results("
    SELECT * FROM " . $wpdb->prefix . "slp_digest
    WHERE config_name = 'application-selected'
  ");
  if (count($result) > 0) {
    return $result[0]->value;
  }
  return null;
}

function saveApplicationIdSelected($application_id)
{
  global $wpdb;
  $result = $wpdb->get_results("
    SELECT * FROM " . $wpdb->prefix . "slp_digest
    WHERE config_name = 'application-selected'
  ");
  if ($result) {
    $result = $wpdb->update(
      $wpdb->prefix . 'slp_digest',
      array('value' => $application_id),
      array('config_name' => 'application-selected'),
      array('%s'),
      array('%s')
    );
  } else {
    $wpdb->insert(
      $wpdb->prefix . 'slp_digest',
      array('config_name' => 'application-selected', 'value' => $application_id),
      array('%s', '%s')
    );
  }


}

function getApplications($digestbuilder_id)
{
  global $apiPath;

  $ch = curl_init();
  curl_setopt($ch, CURLOPT_URL, $apiPath . "/plugin-ep/");
  curl_setopt($ch, CURLOPT_POST, 1);
  curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query(array(
    'method' => 'registerSystemId',
    'system_id' => $digestbuilder_id
  )));

  // Receive server response ...
  curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
  $response = curl_exec($ch);
  curl_close($ch);

  return json_decode($response);
}

add_action('wp_ajax_slp_register', 'slp_ajax_register_action');
function slp_ajax_register_action()
{
  global $apiPath;
  $digestbuilder_id = $_POST['digestbuilder_id'];

  $ch = curl_init();
  curl_setopt($ch, CURLOPT_URL, $apiPath . "/plugin-ep/");
  curl_setopt($ch, CURLOPT_POST, 1);
  curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query(array(
    'method' => 'registerSystemId',
    'system_id' => $digestbuilder_id
  )));

  // Receive server response ...
  curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
  $response = curl_exec($ch);
  curl_close($ch);

  if ($response) {
    global $wpdb;
    $result = $wpdb->get_results("
      SELECT * FROM " . $wpdb->prefix . "slp_digest
      WHERE config_name = 'digestbuilder-id'
    ");

    if ($result) {
      $result = $wpdb->update(
        $wpdb->prefix . 'slp_digest',
        array('value' => $digestbuilder_id),
        array('config_name' => 'digestbuilder-id'),
        array('%s'),
        array('%s')
      );
    } else {
      $wpdb->insert(
        $wpdb->prefix . 'slp_digest',
        array('config_name' => 'digestbuilder-id', 'value' => $digestbuilder_id),
        array('%s', '%s')
      );
    }
  }

  header("Content-Type: application/json");
  echo json_encode($response);

  exit();
}

add_action('wp_ajax_slp_app_details', 'slp_retrieve_app_details');
function slp_retrieve_app_details() {
  $digestbuilder_id = $_POST['digestbuilder_id'];
  $application_id = $_POST['application_id'];

  $data = retrieveAppDetails($digestbuilder_id, $application_id);

  header("Content-Type: application/json");
  echo json_encode($data);

  exit();
} 

function retrieveAppDetails($dbId = null, $appId = null) 
{
  global $apiPath;

  // DB parameters
  $digestbuilder_id = $dbId;
  $application_id = $appId;
  if (!$digestbuilder_id || !$application_id) {
    $digestbuilder_params = get_digestbuilder_params();
    $digestbuilder_id = $digestbuilder_params['digestbuilder_id'];
    $application_id = $digestbuilder_params['application_id'];
  }

  if ($digestbuilder_id && $application_id) {
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $apiPath . "/plugin-ep/");
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query(array(
      'method' => 'getAppDetails',
      'db_id' => $digestbuilder_id,
      'app_id' => $application_id
    )));

    // Receive server response ...
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $response = curl_exec($ch);
    curl_close($ch);

    $data = json_decode($response);

    saveDigestBuilderParam('app_icon_path', $data->icon_path);
    saveDigestBuilderParam('ios_app_id', $data->ios_app_id);
    saveDigestBuilderParam('android_app_id', $data->android_app_id);
    saveDigestBuilderParam('ios_app_url', $data->ios_app_url);
    saveDigestBuilderParam('android_app_url', $data->android_app_url);
    saveDigestBuilderParam('app_name', $data->app_name);
    saveDigestBuilderParam('org_name', $data->org_name);
    saveDigestBuilderParam('subtitle', $data->subtitle);

    return $data;
  }
  return null;
}

function saveDigestBuilderParam($key, $value) {
  global $wpdb;
  $result = $wpdb->get_results("
    SELECT * FROM " . $wpdb->prefix . "slp_digest
    WHERE config_name = '" . $key . "'
  ");

  if ($result) {
    $result = $wpdb->update(
      $wpdb->prefix . 'slp_digest',
      array('value' => $value),
      array('config_name' => $key),
      array('%s'),
      array('%s')
    );
  } else {
    $wpdb->insert(
      $wpdb->prefix . 'slp_digest',
      array('config_name' => $key, 'value' => $value),
      array('%s', '%s')
    );
  }
}

function save_app_details($icon_path, $ios_app_id, $android_app_id) {
  // Download the icon
  // $url = 'https://media.geeksforgeeks.org/wp-content/uploads/geeksforgeeks-6-1.png';  
  // $img = 'logo.png';  
  
  // // Function to write image into file 
  // file_put_contents($img, file_get_contents($url)); 
}

//add_action( 'wp_slp_async_updated_option', 'updated_option_callback', 10, 2 );
//function updated_option_callback($option, $value) {
//  if ($option == "options_dd_perc" || $option == "options_dd_message" || $option == "options_dd_bardesc") {
//    // DB parameters
//    $digestbuilder_params = get_digestbuilder_params();
//    $digestbuilder_id = $digestbuilder_params['digestbuilder_id'];
//    $application_id = $digestbuilder_params['application_id'];
//
//    $dd_message = get_field( 'dd_message', 'option' );
//    $dd_bardesc = get_field( 'dd_bardesc', 'option' );
//    $dd_perc = get_field( 'dd_perc', 'option' );
//
//    global $apiPath;
//
//    $ch = curl_init();
//    curl_setopt($ch, CURLOPT_URL, $apiPath . "/plugin-ep/");
//    curl_setopt($ch, CURLOPT_POST, 1);
//    curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query(array(
//      'method' => 'updateDonationBlock',
//      'db_id' => $digestbuilder_id,
//      'app_id' => $application_id,
//      'dd_message' => $dd_message,
//      'dd_bardesc' => $dd_bardesc,
//      'dd_perc' => $dd_perc
//    )));
//
//    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
//    curl_exec($ch);
//    curl_close($ch);
//  }
//}

add_action( 'wp_slp_async_save_post', 'save_post_callback', 10, 2 );
function save_post_callback($post_id, $post)
{
  if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE)
    return;
  if (defined('DOING_AJAX') && DOING_AJAX)
    return;
  if (wp_is_post_revision($post_id))
    return;
  if (wp_is_post_autosave($post_id))
    return;
  if (!current_user_can('edit_post', $post_id))
    return;
  if ($post != null && $post->post_title == "Auto Draft")
    return;

  // $file = plugin_dir_path(__FILE__) . "log.txt";
  // $content = file_get_contents($file);
  // $content = "aha " . json_encode($result[0]->value);
  // $content = "TESTING " . $post->ID . " " . $post->post_title . " " . $post->post_status;
  // $content = "\nTESTING " . $times . " " . $post->post_type . " " . plugin_dir_path(__FILE__);
  // var_dump($_SERVER['DOCUMENT_ROOT']);

  // Write the contents back to the file
  // file_put_contents($file, $log_content);
  // file_put_contents($file, $content);

  // DB parameters
  $digestbuilder_params = get_digestbuilder_params();
  $digestbuilder_id = $digestbuilder_params['digestbuilder_id'];
  $application_id = $digestbuilder_params['application_id'];

  // Category ids
  $categories = get_the_category($post->ID);
  $catIdArray = array();
  if (is_array($categories)) {
    foreach ($categories as $cat) {
      $catIdArray[] = $cat->term_id;
    }
  }
  $categoryIds = json_encode($catIdArray);

  // Tag ids
  $tags = get_the_tags($post->ID);
  $tagIdArray = array();
  if (is_array($tags)) {
    foreach ($tags as $tag) {
      $tagIdArray[] = $tag->term_id;
    }
  }
  $tagIds = json_encode($tagIdArray);

  global $apiPath;

  $ch = curl_init();
  curl_setopt($ch, CURLOPT_URL, $apiPath . "/plugin-ep/");
  curl_setopt($ch, CURLOPT_POST, 1);
  curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query(array(
    'method' => 'saveStory',
    'db_id' => $digestbuilder_id,
    'app_id' => $application_id,
    'content_id' => $post->ID,
    'name' => $post->post_title,
    'published' => $post->post_status == 'publish',
    'cat_ids' => json_decode($categoryIds),
    'tag_ids' => json_decode($tagIds),
    'post_type' => $post->post_type,
    'date' => $post->post_date_gmt
  )));

  // Receive server response
  curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
  curl_exec($ch);
  curl_close($ch);

  return;
}

function get_digestbuilder_params() {
  global $wpdb;

  $result = $wpdb->get_results("
      SELECT * FROM " . $wpdb->prefix . "slp_digest
      WHERE config_name = 'digestbuilder-id'
    ");
  $digestbuilder_id = $result[0]->value;

  // Get app ID
  $result = $wpdb->get_results("
      SELECT * FROM " . $wpdb->prefix . "slp_digest
      WHERE config_name = 'application-selected'
    ");
  $application_id = $result[0]->value;

  return array(
    'digestbuilder_id' => $digestbuilder_id,
    'application_id' => $application_id
  );
}

function saveRegisteredCustomPostTypes($postTypes)
{
  global $wpdb;
  $result = false;
  $configName = "custom_post_types";

  $postTypeList = array();
  foreach ($postTypes as $postType) {
    $postTypeList[] = $postType->name;
  }

  $result = $wpdb->get_results(
    "SELECT * FROM " . $wpdb->prefix . "slp_digest"
      . " WHERE config_name = \"$configName\""
  );

  $postTypesFormatted = implode(',', $postTypeList);

  if ($result) {
    $result = $wpdb->update(
      $wpdb->prefix . 'slp_digest',
      array('value' => $postTypesFormatted),
      array('config_name' => $configName),
      array('%s'),
      array('%s')
    );
  } else {
    $result = $wpdb->insert(
      $wpdb->prefix . 'slp_digest',
      array('config_name' => $configName, 'value' => $postTypesFormatted),
      array('%s', '%s')
    );
  }

  if ($wpdb->last_error) {
    return array(
      'result' => 'error',
      'message' => 'Error saving Custom Post Types to the database. Please try again.'
    );
  } else {
    global $apiPath;

    $digestbuilder_params = get_digestbuilder_params();
    $digestbuilder_id = $digestbuilder_params['digestbuilder_id'];
    $application_id = $digestbuilder_params['application_id'];

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $apiPath . "/plugin-ep/");
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query(array(
      'method' => 'saveWpCustomPostTypes',
      'db_id' => $digestbuilder_id,
      'app_id' => $application_id,
      'custom_post_types' => $postTypesFormatted
    )));

    // Receive server response ...
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $response = curl_exec($ch);
    curl_close($ch);

    return array('result' => 'success');
  }
}


function getRegisteredCustomPostTypes()
{
  $args = array(
    'public'   => true,
    '_builtin' => false,
  );

  $output = 'objects';
  $operator = 'and';

  $post_types = get_post_types($args, $output, $operator);
  $enabledPostTypesList = getEnabledCustomPostTypes();

  if ($enabledPostTypesList) {
    foreach ($enabledPostTypesList as $enabledItem) {
      foreach ($post_types as $postTypeItem) {
        if ($enabledItem == $postTypeItem->name) {
          $postTypeItem->item_checked = true;
        }
      }
    }
  }

  return $post_types;
}

function getEnabledCustomPostTypes() {
  global $wpdb;
  $configName = "custom_post_types";
  $result = $wpdb->get_results("
    SELECT * FROM " . $wpdb->prefix . "slp_digest
    WHERE config_name = '" . $configName . "'
  ");

  if ($result) {
    $enabledPostTypes = $result[0]->value;
    $enabledPostTypesList = explode(',', $enabledPostTypes);
    return $enabledPostTypesList;
  } else {
    return array();
  }
}

add_action( 'init', 'slp_add_custom_post_type_json_api', 30 );
function slp_add_custom_post_type_json_api()
{
  global $wp_post_types;
  $enabledPostTypesList = getEnabledCustomPostTypes();
  if ($enabledPostTypesList) {
    foreach ($enabledPostTypesList as $enabledItem) {
      if (array_key_exists($enabledItem, $wp_post_types)) {
        $wp_post_types[$enabledItem]->show_in_rest = true;
      }
    }
  }
}

function slp_list_donation_drive_data()
{
  // check if get_field exists
  if (function_exists('get_field')) {
    $dd_message = get_field('dd_message', 'option');
    $dd_bardesc = get_field('dd_bardesc', 'option');
    $dd_perc = get_field('dd_perc', 'option');
    $dd_show_countdown_clock = get_field('dd_show_countdown_clock', 'option');
    $dd_countdown_clock = get_field('dd_countdown_clock', 'option');

    return array(
      'dd_message' => $dd_message,
      'dd_bardesc' => $dd_bardesc,
      'dd_perc' => $dd_perc,
      'dd_show_countdown_clock' => $dd_show_countdown_clock,
      'dd_countdown_clock' => $dd_countdown_clock,
    );
  } else {
    return array();
  }
}

add_action('rest_api_init', function () {
  register_rest_route('slp-plugin/v1', '/donation-drive', array(
    'methods' => 'GET',
    'callback' => 'slp_list_donation_drive_data',
  ) );
});


