<?php
/*
    Plugin Name: DigestBuilder 
    Plugin URI: http://www.digestbuilder.com/
    Description: Simple management for your DigestBuilder mobile app.
    Author: DigestBuilder team
    Version: 1.0.37
    Author URI: http://www.digestbuilder.com/
 */

// Plugin Updater 
require 'plugin-update-checker/plugin-update-checker.php';
$myUpdateChecker = Puc_v4_Factory::buildUpdateChecker(
  'https://bitbucket.org/skyloft/digestbuilder-wordpress-plugin',
  __FILE__,
  'digestbuilder-wordpress-plugin'
);
$myUpdateChecker->setAuthentication(array(
  'consumer_key' => 'W9baec2kCaqTHUAV7v',
  'consumer_secret' => '5bCZRhqdH2XTeANBctSEP7QW37CwHnnM',
));
$myUpdateChecker->setBranch('master');


require_once 'digest_functions.php';

register_activation_hook(__FILE__, 'slp_digest_install');
register_deactivation_hook(__FILE__, 'slp_digest_deactivate');

function slp_digest_install()
{
  if (!current_user_can('activate_plugins')) return;

  global $wpdb;
  global $slp_digest_db_version;

  $table_name = $wpdb->prefix . 'slp_digest';
  $charset_collate = $wpdb->get_charset_collate();

  $sql = "CREATE TABLE $table_name (
    id INT(11) NOT NULL AUTO_INCREMENT,
    config_name VARCHAR(128) NOT NULL,
    value VARCHAR(128) NOT NULL,
    time datetime DEFAULT '0000-00-00 00:00:00' NOT NULL,
    PRIMARY KEY (id)
  ) $charset_collate;";

  require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
  dbDelta($sql);

  add_option('slp_digest_db_version', $slp_digest_db_version);

  slp_digest_data();
}

function slp_digest_data()
{
  global $wpdb;
  $table_name = $wpdb->prefix . 'slp_digest';

  $wpdb->insert($table_name, array(
    'config_name' => 'slp_digest_config_id',
    'value' => 1,
  ), array('%s', '%d'));

  $wpdb->insert($table_name, array(
    'config_name' => 'mobile_featured_image',
    'value' => 1,
  ), array('%s', '%d'));
}

function slp_digest_deactivate()
{
  if (!current_user_can('activate_plugins')) return;

  global $wpdb;
  $table_name = $wpdb->prefix . 'slp_digest';

  $sql = "DROP TABLE IF EXISTS $table_name;";
  $wpdb->query($sql);
  delete_option("my_plugin_db_version");
}

function slp_digest_admin()
{
  include('slp_digest_admin.php');
}

function slp_admin_actions()
{
  // Add to top level menu
  add_menu_page(
    'Digest App',
    'Digest App',
    'edit_published_posts',
    plugin_dir_path(__FILE__) . 'slp_digest_admin.php',
    null,
    'dashicons-smartphone',
    100
  );
}
add_action('admin_menu', 'slp_admin_actions');


if (getMobileFeaturedImageEnabled()) {
  // Init the meta box
  add_action('after_setup_theme', 'slp_custom_postimage_setup');
  function slp_custom_postimage_setup()
  {
    add_action('add_meta_boxes', 'custom_postimage_meta_box');
    add_action('save_post', 'custom_postimage_meta_box_save');
  }
}

// Include coauthor info into WP-JSON API
if (function_exists('get_coauthors')) {
  add_action('rest_api_init', 'slp_custom_register_coauthors');

  function slp_custom_register_coauthors()
  {
    $postTypes = array_merge(array('post'), getEnabledCustomPostTypes());
    foreach ($postTypes as $postType) {
      register_rest_field(
        $postType,
        'slp_coauthors',
        array(
          'get_callback' => 'slp_custom_get_coauthors',
          'update_callback' => null,
          'schema' => null,
        )
      );
    }
  }

  function slp_custom_get_coauthors($object, $field_name, $request)
  {
    $coauthors = get_coauthors($object['id']);

    $authors = array();
    foreach ($coauthors as $author) {
      $authorLink = $author instanceof WP_User
        ? get_author_posts_url($author->ID)
        : get_author_posts_url($author->ID, $author->user_login);
      $authors[] = array(
        'display_name' => $author->display_name,
        'user_nicename' => $author->user_nicename,
        'author_link' => $authorLink
      );
    };

    return $authors;
  }
}

// Resgister ACF into REST api
if (function_exists('get_fields')) {
  add_action('rest_api_init', 'slug_register_acf');
  function slug_register_acf()
  {
    $postTypes = array_merge(array('post'), getEnabledCustomPostTypes());
    foreach ($postTypes as $postType) {
      register_rest_field($postType, 'slp_acf', array(
        'get_callback' => function ($data) {
          return get_fields($data['id']);
        },
      ));
    }
  }
}

// Adds custom taxonomies to WP API
function slp_add_custom_taxonomy_to_api()
{
  $taxonomies = get_taxonomies('', 'objects');

  foreach ($taxonomies as $taxonomy) {
    $taxonomy->show_in_rest = true;
  }
}
add_action('init', 'slp_add_custom_taxonomy_to_api', 30);

// Add primary category selection to WP API
add_action('rest_api_init', 'slp_register_primary_category');
function slp_register_primary_category()
{
  if (class_exists('WPSEO_Primary_Term')) {
    $postTypes = array_merge(array('post'), getEnabledCustomPostTypes());
    foreach ($postTypes as $postType) {
      register_rest_field($postType, 'slp_primary_category', array(
        'get_callback' => function ($data) {
          $wpseo_primary_term = new WPSEO_Primary_Term('category', get_the_id());
          $wpseo_primary_term = $wpseo_primary_term->get_primary_term();
          $term = get_term($wpseo_primary_term);
          if (!is_wp_error($term)) {
            return array(
              'id' => $term->term_id,
              'name' => $term->name
            );
          }
        }
      ));
    }
  }
}

function slp_header_metadata()
{
  $bannerData = getSmartBannerData();

  $smartBannerEnabled = filter_var($bannerData['smart_banner_enabled'], FILTER_VALIDATE_BOOLEAN);

  if ($smartBannerEnabled) {
    ?>
    <meta name="apple-itunes-app" content="app-id=<?php echo $bannerData['ios_app_id'] ?>">
    <script type="text/javascript">
      (function() {
        const userAgent = navigator.userAgent || "";
        const isAndroid = /Android/i.test(userAgent);
        const isIOS = /iPad|iPhone|iPod/.test(userAgent) && !window.MSStream;
        
        // On iOS, Chrome uses "CriOS", Firefox uses "FxiOS", Edge uses "EdgiOS"
        // Safari doesn't have these identifiers
        const isIOSChrome = /CriOS/i.test(userAgent);
        const isIOSFirefox = /FxiOS/i.test(userAgent);
        const isIOSEdge = /EdgiOS/i.test(userAgent);
        const isIOSSafari = isIOS && !isIOSChrome && !isIOSFirefox && !isIOSEdge;
        
        // Determine platform and banner settings
        let platform = null;
        let bannerKey = null;
        let appUrl = null;
        let appLabel = null;
        
        if (isAndroid) {
          platform = "android";
          bannerKey = "hideAndroidAppBannerV1";
          appUrl = "<?php echo $bannerData['android_app_url']; ?>";
          appLabel = "Get our Android app";
        } else if (isIOS && !isIOSSafari) {
          // iOS but not Safari (Chrome, Firefox, Edge, etc.)
          platform = "ios";
          bannerKey = "hideIOSAppBannerV1";
          appUrl = "<?php echo $bannerData['ios_app_url']; ?>";
          appLabel = "Get our iOS app";
        }
        
        // Exit if not a supported platform, missing URL, or banner was dismissed
        if (!platform || !appUrl || localStorage.getItem(bannerKey) === "1") return;

        async function shouldShowBanner() {
          if (platform === "android" && navigator.getInstalledRelatedApps) {
            try {
              const PKG = "<?php echo $bannerData['android_app_id']; ?>";
              const relatedApps = await navigator.getInstalledRelatedApps();
              return !relatedApps.some(a => a.platform === "play" && a.id === PKG);
            } catch {
              return true;
            }
          }
          return true;
        }

        function createBanner() {
          const banner = document.createElement("div");
          banner.id = platform + "-app-banner";
          banner.setAttribute("role", "region");
          banner.setAttribute("aria-label", appLabel);
          banner.style.cssText = `
            position:fixed;left:0;right:0;top:0;display:flex;gap:.75rem;
            background:#111;color:#fff;padding:.9rem 1rem;align-items:center;
            z-index:9999;font-family:system-ui,sans-serif
          `;

          banner.innerHTML = `
            <div style="width:40px;height:40px;border-radius:8px;background:#333;flex-shrink:0;display:flex;align-items:center;justify-content:center;overflow:hidden">
              <img src="<?php echo $bannerData['app_icon_path']; ?>" alt="App logo" style="width:36px;height:36px;border-radius:6px;display:block;">
            </div>
            <div style="flex:1">
              <p style="margin:0;font-weight:700;font-size:.95rem">${appLabel}</p>
              <p style="margin:.15rem 0 0;font-size:.8rem;opacity:.8">Faster, offline reading & native notifications.</p>
            </div>
            <div style="display:flex;gap:.5rem">
              <a href="${appUrl}"
                style="padding:.5rem .8rem;border-radius:999px;background:#fff;color:#111;
                        text-decoration:none;font-weight:600;font-size:.85rem">Open</a>
            </div>
            <button aria-label="Dismiss"
                    style="background:none;border:0;color:#aaa;font-size:1.2rem;line-height:1;margin-left:.5rem">&times;</button>
          `;

          function addBodyPadding() {
            if (document.body && banner.offsetHeight) {
              document.body.style.paddingTop = banner.offsetHeight + 'px';
            }
          }

          function removeBodyPadding() {
            if (document.body) {
              document.body.style.paddingTop = '';
            }
          }

          banner.querySelector("button").addEventListener("click", () => {
            removeBodyPadding();
            banner.remove();
            localStorage.setItem(bannerKey, "1");
          });

          function insertBanner() {
            if (document.body) {
              document.body.appendChild(banner);
              setTimeout(addBodyPadding, 0);
            } else {
              if (document.readyState === 'loading') {
                document.addEventListener('DOMContentLoaded', () => {
                  document.body.appendChild(banner);
                  setTimeout(addBodyPadding, 0);
                });
              } else {
                setTimeout(() => {
                  if (document.body) {
                    document.body.appendChild(banner);
                    setTimeout(addBodyPadding, 0);
                  }
                }, 0);
              }
            }
          }

          insertBanner();
        }

        shouldShowBanner().then(show => {
          if (show) createBanner();
        });
      })();
    </script>
<?php
  }
}
add_action('wp_head', 'slp_header_metadata');

function slp_get_draft_queue_by_category( $data ) {
  slp_get_draft_queue($data['id'], 'category');
}

function slp_get_draft_queue_by_tag( $data ) {
  slp_get_draft_queue($data['id'], 'tag');
}

function slp_get_draft_queue_by_custom_post_type( $data ) {
  slp_get_draft_queue($data['id'], 'custom');
}

function slp_get_draft_queue( $id, $type ) {
  $args = array();

  if ($type == 'category') {
    $args = array(
      'posts_per_page' => 20, 
      'offset' => 0, 
      'category' => $id,
      'orderby'=> 'post_date',
      'order'=> 'ASC', 
      'post_status' => 'future' 
    );
  } else if ($type == 'tag') {
    $args = array(
      'posts_per_page' => 20, 
      'offset' => 0, 
      'tag_id' => $id,
      'orderby'=> 'post_date',
      'order'=> 'ASC', 
      'post_status' => 'future' 
    );
  } else if ($type == 'custom') {
    $args = array(
      'posts_per_page' => 20, 
      'offset' => 0, 
      'post_type' => $id,
      'orderby'=> 'post_date',
      'order'=> 'ASC', 
      'post_status' => 'future' 
    );
  }

  $posts = get_posts($args);

  if ( empty( $posts ) ) {
    return null;
  }

  $result = array();

  foreach ($posts as $key => $item) {
    // Category ids
    $categories = get_the_category($item->ID);
    $catIdArray = array();
    if (is_array($categories)) {
      foreach ($categories as $cat) {
        $catIdArray[] = $cat->term_id;
      }
    }
    $categoryIds = json_encode($catIdArray);

    // Tag ids
    $tags = get_the_tags($item->ID);
    $tagIdArray = array();
    if (is_array($tags)) {
      foreach ($tags as $tag) {
        $tagIdArray[] = $tag->term_id;
      }
    }
    $tagIds = json_encode($tagIdArray);

    $result[$key] = array(
      'id' => $item->ID,
      'title' => $item->post_title,
      'status' => $item->post_status,
      'date' => $item->post_date_gmt,
      'cat_ids' => json_decode($categoryIds),
      'tag_ids' => json_decode($tagIds),
    );
  }

  header('Content-Type: application/json; charset=utf-8');
  echo json_encode($result);
}

if (getDraftQueueEnabled()) {
  add_action( 'rest_api_init', function () {
    register_rest_route( 'digestbuilder/v1', '/category/(?P<id>\d+)', array(
      'methods' => 'GET',
      'callback' => 'slp_get_draft_queue_by_category',
    ) );
    register_rest_route( 'digestbuilder/v1', '/tag/(?P<id>\d+)', array(
      'methods' => 'GET',
      'callback' => 'slp_get_draft_queue_by_tag',
    ) );
    register_rest_route( 'digestbuilder/v1', '/custom/(?P<id>[a-zA-Z0-9-]+)', array(
      'methods' => 'GET',
      'callback' => 'slp_get_draft_queue_by_custom_post_type',
    ) );
  } );
}
