<?php

require_once 'digest_functions.php';

?>
<!doctype html>
<html lang="en">

<head>
  <title></title>

  <style type="text/css">
    .clr {
      clear: both;
    }

    .digest-app-wrapper {
      position: relative;
      border: 1px solid #e5e5e5;
      box-shadow: 0 1px 1px rgba(0, 0, 0, .04);
      background: #fff;
      min-width: 255px;
      max-width: 755px;
      margin: 20px 0;
    }

    .digest-app-content h2 {
      font-size: 14px;
      padding: 8px 12px;
      margin: 0;
      line-height: 1.4;
      border-bottom: 1px solid #eee;
    }

    .digest-app-subcontent {
      margin: 0 12px 20px;
    }

    .digest-app-content p {
      margin: 10px 0 5px;
    }

    .digest-app-content p span {
      padding-right: 10px;
    }

    .digest-app-content select {
      padding: 2px;
      line-height: 28px;
      height: 28px;
      font-size: 14px;
      border-radius: 0;
      border: 1px solid #ddd;
      box-shadow: inset 0 1px 2px rgba(0, 0, 0, .07);
      background-color: #fff;
      color: #32373c;
      outline: 0;
      transition: 50ms border-color ease-in-out;
      min-width: 240px;
    }

    #select-application-wrapper {
      display: none;
    }

    .db-store-info-container {
      margin: 20px 0 0;
      padding: 15px 18px;
      display: flex;
      border-top: 1px dashed #d9d9d9;
      border-left: 1px dashed #d9d9d9;
      border-right: 1px dashed #d9d9d9;
      border-radius: 6px 6px 0 0;
      box-sizing: border-box;
    }

    .db-thumbnail-wrapper {
      margin: 0 20px 0 0;
    }

    .db-thumbnail-wrapper img {
      border-radius: 14px;
      border: 2px solid #ddd;
      width: 120px;
    }

    .db-store-info-urls {
      margin: 0;
    }

    .db-store-info-urls input {
      width: 300px;
    }

    #syncButton {
      margin: 10px 10px 10px 0;
    }

    .sync-icon {
      font: 400 20px/1 dashicons;
      vertical-align: middle;
    }

    .sync-icon:before {
      content: "\f463";
      top: 2px;
    }

    .db-store-controls {
      text-align: right;
      background-color: rgba(0, 0, 0, .03);
      border-top: 1px solid #eee;
      border-bottom: 1px dashed #d9d9d9;
      border-left: 1px dashed #d9d9d9;
      border-right: 1px dashed #d9d9d9;
      border-radius: 0 0 6px 6px;
    }
    .select-container {
      border: 1px solid #eee;
      padding: 0 10px;
      max-height: 200px;
      overflow: scroll;
    }
  </style>

  <link rel="stylesheet" href="//code.jquery.com/ui/1.12.1/themes/base/jquery-ui.css">
  <script src="https://code.jquery.com/jquery-1.12.4.js"></script>
  <script src="https://code.jquery.com/ui/1.12.1/jquery-ui.js"></script>
</head>


<?php

if (isset($_POST['pi_hidden'])) {
  $saveResult = array();

  // Save mobile feature image
  $mobileFeaturedImageEnabled = $_POST['mobile_featured_image_enabled'] == "on" ? 1 : 0;
  $saveResult[] = saveMobileFeaturedImageEnabled($mobileFeaturedImageEnabled);

  // Save mobile feature image
  $draftQueueEnabled = $_POST['draft_queue_enabled'] == "on" ? 1 : 0;
  $saveResult[] = saveDraftQueueEnabled($draftQueueEnabled);

  // Save applicationId selected
  $applicationIdSelected = $_POST['application-selector'];
  if ($applicationIdSelected) {
    saveApplicationIdSelected($applicationIdSelected);
  }

  // Save smart banner info
  $saveResult[] = saveSmartBannerData(
    isset($_POST['smart_banner_enabled']) ? true : false,
    $_POST['smart_banner_days_hidden'],
    $_POST['smart_banner_days_reminder']
  );

  // Save custom post types info
  $postTypes = extractSelectedCustomPostTypes($_POST);
  $saveResult[] = saveRegisteredCustomPostTypes($postTypes);
  echo '<div class="clr"></div>';

  $errorMessage = null;
  foreach ($saveResult as $item) {
    if ($item['result'] == 'error') {
      $errorMessage = $item['message'];
      break;
    }
  }

  if ($errorMessage != null) {
    echo '<div class="update-nag"><p><strong>' . $errorMessage . '</strong></p></div>';
  } else {
    echo '<div class="updated"><p><strong>Saved successfully</strong></p></div>';
  }
}

// $tagToExclude = getTagToExclude();
$tags = get_tags(array('hide_empty' => false));
$mobileFeaturedImageEnabled = getMobileFeaturedImageEnabled();
$draftQueueEnabled = getDraftQueueEnabled();
$bannerData = getSmartBannerData();
$digestbuilder_id = getDigestBuilderId();
$customPostTypes = getRegisteredCustomPostTypes();

if ($digestbuilder_id) {
  $applicationIdSelected = getApplicationIdSelected();
  $applications = getApplications($digestbuilder_id);
}

?>

<body>

  <div class="wrap">
    <?php echo "<h1>" . __('Digest App Settings', 'oscimp_trdom') . "</h1>"; ?>
    <form name="oscimp_form" method="post" action="<?php echo str_replace('%7E', '~', $_SERVER['REQUEST_URI']); ?>">
      <!-- Digest Builder ID -->
      <div class="digest-app-wrapper">
        <div class="digest-app-content">
          <?php echo "<h2>" . __('DigestBuilder ID', 'oscimp_trdom') . "</h2>"; ?>
          <div class="digest-app-subcontent">
            <p>
              <?php _e("Enter your DigestBuilder ID:"); ?>
            </p>
            <input type="text" id="digest-builder-id" name="digest-builder-id" value="<?php echo $digestbuilder_id; ?>">
            <button id="registerButton" class="button button-primary button-small"><?php _e('Connect with DigestBuilder', 'oscimp_trdom') ?></button>
            <div id="select-application-wrapper">
              <p>
                <?php _e("Select app"); ?>
              </p>
              <select name="application-selector" id="application-selector">
                <!-- <option value=""></option> -->
                <?php foreach ($applications as $item) { ?>
                  <option value="<?php echo $item->id ?>" <?php if ($item->id == $applicationIdSelected) { ?> selected="selected" <?php } ?>><?php echo $item->name ?></option>
                <?php
                } ?>
              </select>
            </div>
          </div>
        </div>
      </div>

      <!-- MOBILE FEATURED IMAGE -->
      <div class="digest-app-wrapper">
        <div class="digest-app-content">
          <h2>Mobile Featured Image</h2>
          <div class="digest-app-subcontent">
            <p>
              <span><?php _e("Enable App-specific featured image: "); ?></span>
              <input type="checkbox" name="mobile_featured_image_enabled" <?php echo $mobileFeaturedImageEnabled ? "checked" : "" ?>>
            </p>
          </div>
        </div>
      </div>

      <!-- Smart Banner Settings -->
      <div class="digest-app-wrapper">
        <div class="digest-app-content">
          <?php echo "<h2>" . __('Smart Banner Settings', 'oscimp_trdom') . "</h2>"; ?>
          <div class="digest-app-subcontent">
            <p>
              <span><?php _e("Enable Smart Banner"); ?></span>
              <input type="checkbox" name="smart_banner_enabled" <?php echo $bannerData['smart_banner_enabled'] == "1" ? "checked" : "" ?>>
            </p>
            <p class="digest-input">
              <span><?php _e("Days to hide banner after close button is clicked:"); ?></span>
              <input type="text" name="smart_banner_days_hidden" value="<?php echo $bannerData['days_hidden'] ?>">
            </p>
            <p class="digest-input">
              <span><?php _e("Days to hide banner after \"VIEW\" button is clicked:"); ?></span>
              <input type="text" name="smart_banner_days_reminder" value="<?php echo $bannerData['days_reminder'] ?>">
            </p>
            <div class="db-store-info-container">
              <div class="db-thumbnail-wrapper">
                <img src="<?php echo array_key_exists('app_icon_path', $bannerData) ? $bannerData['app_icon_path'] : 'https://api.digestbuilder.com/images/db-upload-placeholder.png' ?>" border="0" />
              </div>
              <div class="db-store-info-urls">
                <p>
                  <span>App Store URL:</span>
                  <input id="db-appstore-url" type="text" value="<?php echo array_key_exists('ios_app_url', $bannerData) ? $bannerData['ios_app_url'] : ''?>" disabled>
                </p>
                <p>
                  <span>Play Store URL:</span>
                  <input id="db-playstore-url" type="text" value="<?php echo array_key_exists('android_app_url', $bannerData) ? $bannerData['android_app_url'] : '' ?>" disabled>
                </p>
              </div>
            </div>
            <div class="db-store-controls">
              <button id="syncButton" class="button button-primary button-small">
                <span class="sync-icon"></span>
                Sync with DigestBuilder
              </button>
            </div>
          </div>
        </div>
      </div>

      <!-- SELECT CUSTOM POST TYPES -->
      <div class="digest-app-wrapper">
        <div class="digest-app-content">
          <?php echo "<h2>" . __('Enable Custom Posts', 'oscimp_trdom') . "</h2>"; ?>

          <input type="hidden" name="pi_hidden" value="Y">
          <div class="digest-app-subcontent">
            <p>
              <?php _e("Select Custom Post Types to use in DigestBuilder: "); ?>
            </p>
            <div class="select-container">
              <?php foreach ($customPostTypes as $key => $postType) { ?>
                <p>
                  <input type="checkbox" name="registered_post_type_<?php echo $key; ?>" <?php echo property_exists($postType, 'item_chceked') && $postType->item_checked ? "checked" : ""; ?>>
                  <span><?php _e($postType->label); ?></span>
                </p>
              <?php } ?>
            </div>
          </div>
        </div>
      </div>
      
      <!-- ENABLE DRAFT QUEUE -->
      <div class="digest-app-wrapper">
        <div class="digest-app-content">
          <h2>Draft Queue</h2>
          <div class="digest-app-subcontent">
            <p>
              <span><?php _e("Enable draft queue in DigestBuilder: "); ?></span>
              <input type="checkbox" name="draft_queue_enabled" <?php echo $draftQueueEnabled ? "checked" : "" ?>>
            </p>
          </div>
        </div>
      </div>
      

      <input class="button button-primary button-large" type="submit" name="Submit" value="<?php _e('Save App Settings', 'oscimp_trdom') ?>" />
    </form>
  </div>

  <script type="text/javascript">
    var digestbuilder_id = "<?php echo $digestbuilder_id; ?>";
    var applicationIdSelected = "<?php echo $applicationIdSelected; ?>";
    if (digestbuilder_id) {
      $('#select-application-wrapper').show();
    }

    $(function() {
      $.widget("custom.combobox", {
        _create: function() {
          this.wrapper = $("<span>")
            .addClass("custom-combobox")
            .insertAfter(this.element);

          this.element.hide();
          this._createAutocomplete();
          this._createShowAllButton();
        },

        _createAutocomplete: function() {
          var selected = this.element.children(":selected"),
            value = selected.val() ? selected.text() : "";

          this.input = $("<input>")
            .appendTo(this.wrapper)
            .val(value)
            .attr("title", "")
            .addClass("custom-combobox-input ui-widget ui-widget-content ui-state-default ui-corner-left")
            .autocomplete({
              delay: 0,
              minLength: 0,
              source: $.proxy(this, "_source")
            })
            .tooltip({
              classes: {
                "ui-tooltip": "ui-state-highlight"
              }
            });

          this._on(this.input, {
            autocompleteselect: function(event, ui) {
              ui.item.option.selected = true;
              this._trigger("select", event, {
                item: ui.item.option
              });
            },

            autocompletechange: "_removeIfInvalid"
          });
        },

        _createShowAllButton: function() {
          var input = this.input,
            wasOpen = false;

          $("<a>")
            .attr("tabIndex", -1)
            // .attr( "title", "Show All Items" )
            .tooltip()
            .appendTo(this.wrapper)
            .button({
              icons: {
                primary: "ui-icon-triangle-1-s"
              },
              text: false
            })
            .removeClass("ui-corner-all")
            .addClass("custom-combobox-toggle ui-corner-right")
            .on("mousedown", function() {
              wasOpen = input.autocomplete("widget").is(":visible");
            })
            .on("click", function() {
              input.trigger("focus");

              // Close if already visible
              if (wasOpen) {
                return;
              }

              // Pass empty string as value to search for, displaying all results
              input.autocomplete("search", "");
            });
        },

        _source: function(request, response) {
          var matcher = new RegExp($.ui.autocomplete.escapeRegex(request.term), "i");
          response(this.element.children("option").map(function() {
            var text = $(this).text();
            if (this.value && (!request.term || matcher.test(text)))
              return {
                label: text,
                value: text,
                option: this
              };
          }));
        },

        _removeIfInvalid: function(event, ui) {

          // Selected an item, nothing to do
          if (ui.item) {
            return;
          }

          // Search for a match (case-insensitive)
          var value = this.input.val(),
            valueLowerCase = value.toLowerCase(),
            valid = false;
          this.element.children("option").each(function() {
            if ($(this).text().toLowerCase() === valueLowerCase) {
              this.selected = valid = true;
              return false;
            }
          });

          // Found a match, nothing to do
          if (valid) {
            return;
          }

          // Remove invalid value
          this.input
            .val("")
            .attr("title", value + " didn't match any item")
          this._delay(function() {
            this.input.tooltip("close").attr("title", "");
          }, 2500);
          this.input.autocomplete("instance").term = "";
        },

        _destroy: function() {
          this.wrapper.remove();
          this.element.show();
        }
      });

      $("#combobox").combobox();
      $("#toggle").on("click", function() {
        $("#combobox").toggle();
      });

      var applications = [];
      $('#registerButton').click(function() {
        const dbId = $('#digest-builder-id').val();
        $.ajax({
          type: "POST",
          url: ajaxurl,
          data: {
            action: 'slp_register',
            digestbuilder_id: dbId.trim()
          }
        }).done(function(data) {
          // console.log("Data Recieved: " + data);
          applications = JSON.parse(data);

          $('#select-application-wrapper').show()
          const selector = $('#application-selector');
          selector.empty();
          for (const item of applications) {
            selector.append(`<option value="${item.id}" ${item.id == applicationIdSelected ? 'selected="selected"' : ''}>${item.name}</option>`);
          }
        });
        return false;
      })

      $('#syncButton').click(function() {
        const dbId = $('#digest-builder-id').val();
        var appId = $("#application-selector").val();
        $.ajax({
          type: "POST",
          url: ajaxurl,
          data: {
            action: 'slp_app_details',
            digestbuilder_id: dbId.trim(),
            application_id: appId
          }
        }).done(function(data) {
          $('.db-thumbnail-wrapper img').attr('src', data.icon_path);
          $('#db-appstore-url').val(data.ios_app_url);
          $('#db-playstore-url').val(data.android_app_url);
        });
        return false;
      })
    });
  </script>

</body>

</html>