<?php 

class SLP_Async_Task extends WP_Async_Task {

	protected $action = 'save_post';

	/**
	 * Prepare data for the asynchronous request
	 *
	 * @throws Exception If for any reason the request should not happen
	 *
	 * @param array $data An array of data sent to the hook
	 *
	 * @return array
	 */
  protected function prepare_data($data){
    $post_id = $data[0];
    return array( 'post_id' => $post_id );
  }

	/**
	 * Run the async task action
	 */
  protected function run_action() {
    $post_id = $_POST['post_id'];
    $post = get_post($post_id);
    if ($post) {
      do_action("wp_slp_async_$this->action", $post->ID, $post);
    }
  }

}

new SLP_Async_Task();

//class SLP_Options_Async_Task extends WP_Async_Task {
//
//	protected $action = 'updated_option';
//
//	/**
//	 * Prepare data for the asynchronous request
//	 *
//	 * @throws Exception If for any reason the request should not happen
//	 *
//	 * @param array $data An array of data sent to the hook
//	 *
//	 * @return array
//	 */
//  protected function prepare_data($data){
//    if (count($data) > 2) {
//      $option = $data[0];
//      $value = $data[2];
//      return array( 
//        'option' => $option,
//        'value' => $value 
//      );
//    }
//    return array();
//  }
//
//	/**
//	 * Run the async task action
//	 */
//  protected function run_action() {
//    $option = $_POST['option'];
//    $value = $_POST['value'];
//    if ($value) {
//      do_action("wp_slp_async_$this->action", $option, $value);
//    }
//  }
//
//}
//
//new SLP_Options_Async_Task();